VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmCockpit 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Cockpit"
   ClientHeight    =   3435
   ClientLeft      =   150
   ClientTop       =   630
   ClientWidth     =   9960
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3435
   ScaleWidth      =   9960
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkFeedback 
      Caption         =   "g-Vector Feedback"
      Height          =   255
      Left            =   7920
      TabIndex        =   23
      Top             =   1320
      Value           =   1  'Checked
      Width           =   1695
   End
   Begin VB.CheckBox chkNull 
      Caption         =   "Null"
      Height          =   255
      Left            =   240
      TabIndex        =   15
      Top             =   1080
      Width           =   975
   End
   Begin VB.CommandButton cmdInitialize 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   240
      TabIndex        =   14
      Top             =   1560
      Width           =   1215
   End
   Begin VB.Frame fraShow 
      Caption         =   "Show"
      Height          =   1095
      Left            =   7680
      TabIndex        =   11
      Top             =   0
      Width           =   2055
      Begin VB.CheckBox chkDirection 
         Caption         =   "Directional Gyro"
         Height          =   255
         Left            =   240
         TabIndex        =   13
         Top             =   720
         Width           =   1695
      End
      Begin VB.CheckBox chkHorizont 
         Caption         =   "Artificial Horizon"
         Height          =   255
         Left            =   240
         TabIndex        =   12
         Top             =   360
         Width           =   1575
      End
   End
   Begin VB.Frame fraSamples 
      Caption         =   "Samples"
      Height          =   3135
      Left            =   1680
      TabIndex        =   3
      Top             =   0
      Width           =   5655
      Begin VB.TextBox TextAnalog 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Index           =   4
         Left            =   4080
         TabIndex        =   10
         Text            =   "0"
         Top             =   240
         Width           =   1335
      End
      Begin VB.TextBox TextAnzahl 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Left            =   4080
         TabIndex        =   9
         Top             =   2400
         Width           =   1335
      End
      Begin VB.TextBox TextAnalog 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Index           =   6
         Left            =   4080
         TabIndex        =   8
         Text            =   "0"
         Top             =   1680
         Width           =   1335
      End
      Begin VB.TextBox TextAnalog 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Index           =   5
         Left            =   4080
         TabIndex        =   7
         Text            =   "0"
         Top             =   960
         Width           =   1335
      End
      Begin VB.TextBox TextAnalog 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Index           =   2
         Left            =   1200
         TabIndex        =   6
         Text            =   "0"
         Top             =   1680
         Width           =   1335
      End
      Begin VB.TextBox TextAnalog 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Index           =   1
         Left            =   1200
         TabIndex        =   5
         Text            =   "0"
         Top             =   960
         Width           =   1335
      End
      Begin VB.TextBox TextAnalog 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   525
         Index           =   0
         Left            =   1200
         TabIndex        =   4
         Text            =   "0"
         Top             =   240
         Width           =   1335
      End
      Begin VB.Label lblSample 
         Alignment       =   1  'Right Justify
         Caption         =   "# Samples"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   2400
         TabIndex        =   22
         Top             =   2520
         Width           =   1575
      End
      Begin VB.Label lblOut 
         Alignment       =   1  'Right Justify
         Caption         =   "C [Grad]"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   6
         Left            =   3000
         TabIndex        =   21
         Top             =   1800
         Width           =   975
      End
      Begin VB.Label lblOut 
         Alignment       =   1  'Right Justify
         Caption         =   "B [Grad]"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   5
         Left            =   3000
         TabIndex        =   20
         Top             =   1080
         Width           =   975
      End
      Begin VB.Label lblOut 
         Alignment       =   1  'Right Justify
         Caption         =   "A [Grad]"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   4
         Left            =   3000
         TabIndex        =   19
         Top             =   360
         Width           =   975
      End
      Begin VB.Label lblOut 
         Alignment       =   1  'Right Justify
         Caption         =   "dC / dt"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   18
         Top             =   1800
         Width           =   975
      End
      Begin VB.Label lblOut 
         Alignment       =   1  'Right Justify
         Caption         =   "dB / dt"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   17
         Top             =   1080
         Width           =   975
      End
      Begin VB.Label lblOut 
         Alignment       =   1  'Right Justify
         Caption         =   "dA / dt"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   16
         Top             =   360
         Width           =   975
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog 
      Left            =   1080
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton ButtonExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   8520
      TabIndex        =   2
      Top             =   2760
      Width           =   1215
   End
   Begin VB.CommandButton ButtonStop 
      Caption         =   "Stop"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   2760
      Width           =   1215
   End
   Begin VB.CommandButton ButtonStart 
      Caption         =   "Start"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   2160
      Width           =   1215
   End
   Begin VB.Menu mnuConfig 
      Caption         =   "Config"
      Begin VB.Menu mnuSampling 
         Caption         =   "Sampling"
      End
   End
End
Attribute VB_Name = "frmCockpit"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Vektorstruktur, 6 Freiheitsgrade. 3 translatorische, 3 rotatorische
' wird fuer Parameteruebergabe an die f_*() Funktionen verwendet
' ACHTUNG: alpha, beta und gamma sind EULERWINKEL, also nicht einfach Rotationen
' um die jeweiligen Achsen. Mehr dazu siehe Transformationen
Private Type VectorType
    xtrans As Double    ' x - Richtung
    ytrans As Double    ' y - Richtung
    ztrans As Double    ' z - Richtung
    arot As Double      ' Alpha = "Bank" = Rot um (Laengsachse = y - Achse)
    brot As Double      ' Beta = "Pitch" = Rot um (Querachse = x - Achse)
    crot As Double      ' Gamma = "Direction" = Rot um (Hochachse = z - Achse)
End Type

Private Sub ButtonExit_Click()
    ' Programm beenden
    End
End Sub

Private Sub ButtonStart_Click()
    ' Diese Routine aquiriert kontinuierlich Daten vom AD und uebergibt
    ' sie dem Artificial Horizont & Virtual Compass
    
    ' Wie koennen mit dem Aufsetzen des Samplings beginnen:
    Dim iStatus As Integer
    Dim iRetval As Integer
    Dim iDevice As Integer
    Dim iDBmodeON As Integer
    Dim iDBmodeOFF As Integer
    Dim ulCount As Long
    Dim iLoopCount As Integer
    Dim iHalfBufsToRead As Integer
    Dim iUnits As Integer
    Dim iSampTB As Integer
    Dim piBuffer() As Integer
    Dim piHalfBuffer() As Integer
    Dim iHalfReady As Integer
    Dim iDAQstopped As Integer
    Dim ulPtsTfr As Long
    Dim iIgnoreWarning As Integer
    Dim lTimeout As Long
    Dim iYieldON As Integer
    
    Dim SampleCounter As Long   ' Zaehler fuer die Anzahl Einzelsampels
    Dim inRecord As Integer     ' Welcher Wert innerhalb des Records?
    Dim iterate As Integer      ' Schlaufenvariable
    Dim realTimebase As Double  ' S_timeBase ist nur ein index 1 - 5
    Dim correctBufferSize As Integer
    Dim tempdouble As Double
    Dim whichDispUpdate As Boolean        ' welches Display soll upgedated werden?
    
    ' Initialisierung
    iDevice% = 1                ' DAQ-Card 1200 immer Device 1
    iDBmodeON% = 1              ' DoubleBufferedMode
    correctBufferSize = S_bufferSize - (S_bufferSize Mod S_NrCh)
    If (correctBufferSize Mod 2) <> 0 Then
        correctBufferSize = correctBufferSize - S_NrCh
    End If
    ReDim piBuffer(correctBufferSize)       ' S_bufferSize muss Vielfaches sein!
    ReDim piHalfBuffer(S_bufferSize)    ' Sicher groesser ...
    iUnits% = 0                 ' immer "Samples pro Sekunde"
    ulCount = correctBufferSize
    iHalfBufsToRead% = 20
    lTimeout& = 180
    iYieldON% = 1
    PosCounter = 0
    Ibank = 0
    Ipitch = 0
    
    ' Abbuchbedingung setzen
    GoOnAquire = True

    ' Disable Buttons
    ButtonExit.Enabled = False
    ButtonStart.Enabled = False
    ButtonStop.Enabled = True

    ' Timeout Setzen
    iStatus% = Timeout_Config(iDevice%, lTimeout&)
    iRetval% = NIDAQErrorHandler(iStatus%, "Timeout_Config", iIgnoreWarning%)

    ' Timebase, SampleInterval und ScanInterval berechnen
    ' iStatus% = DAQ_Rate(S_Freq, iUnits%, S_sampTimebase, S_sampInterval)
    ' bestimmen der echten Timebase:
    ' Bedingungen:
    '   - ZeitproMessung >= 10us (bei Gain < 10) = S_sampInterval/realTimebase
    '   - realTimebase  sampTimebase
    '           100 Hz      5
    '           1k Hz       4
    '           10 kHz      3
    '           100kHz      2
    '           1MHz        1
    '   - scanInterval < 65535, > 2 und > NrCh / realTimebase + 5 us
    '   - SampleRate (Hz) = realTimebase / scanInterval
    
    Select Case S_Freq
        Case 1
            ' 1 Hz
            S_sampTimebase = 3
            S_sampInterval = 2
            realTimebase = 10000
            S_scanInterval = 10000
        Case 10
            ' 10 Hz
            S_sampTimebase = 2
            S_sampInterval = 2
            realTimebase = 100000
            S_scanInterval = 10000
        Case 50
            ' 50 Hz
            S_sampTimebase = 2
            S_sampInterval = 2
            realTimebase = 100000
            S_scanInterval = 2000
        Case 150
            ' 150 Hz
            S_sampTimebase = 1
            S_sampInterval = 10
            realTimebase = 1000000
            S_scanInterval = 6667
        Case 300
            ' 300 Hz
            S_sampTimebase = 1
            S_sampInterval = 10
            realTimebase = 1000000
            S_scanInterval = 3333
        Case 500
            ' 500 Hz
            S_sampTimebase = 1
            S_sampInterval = 10
            realTimebase = 1000000
            S_scanInterval = 2000
        Case 2000
            ' 2000 Hz
            S_sampTimebase = 1
            S_sampInterval = 10
            realTimebase = 1000000
            S_scanInterval = 500
    End Select
    If S_Freq <> 0 Then
        S_scanInterval = CInt((1 / S_Freq) * realTimebase)
    Else
        ' Division by zero, kommt nie vor, hoffentlich ;-)
    End If
     
   
    ' Single ended unipolar input mode setzen
    iStatus% = AI_Configure(iDevice%, -1, 1, 0, 1, 0)
    
    ' Double Buffered Mode
    iStatus% = DAQ_DB_Config(iDevice%, iDBmodeON%)
    iRetval% = NIDAQErrorHandler(iStatus%, "DAQ_DB_Config", iIgnoreWarning%)

    ' Dithering einschalten
    iStatus% = MIO_Config(iDevice%, 1, 0)

    ' Starte Scan Aquisition
    iStatus% = Lab_ISCAN_Start(iDevice%, S_NrCh, S_gain, piBuffer%(0), ulCount, S_sampTimebase, S_sampInterval, S_scanInterval)
    iRetval% = NIDAQErrorHandler(iStatus%, "Lab_ISCAN_Start", iIgnoreWarning%)
    
    RecordCounter = 0
    SampleCounter = 0
    
    ' Loopen und lesen
    While ((iLoopCount% < iHalfBufsToRead%) And (iStatus% = 0) And (GoOnAquire))
        iLoopCount% = 0     ' Ewig
        iStatus% = DAQ_DB_HalfReady(iDevice%, iHalfReady%, iDAQstopped%)
        ' Ist wieder ein halber Buffer lesebereit?
        If ((iHalfReady% = 1) And (iStatus% = 0)) Then
            ' Ja, lesebereit
            iStatus% = DAQ_DB_Transfer(iDevice%, piHalfBuffer%(0), ulPtsTfr&, iDAQstopped%)
            iRetval% = NIDAQErrorHandler(iStatus%, "DAQ_DB_Transfer", 0)
            ' Abfuellen in MessArr - Struktur
            For iterate = 0 To (ulPtsTfr& - 1)
                inRecord = S_NrCh - (SampleCounter Mod (S_NrCh)) - 1
                MessArr(RecordCounter, inRecord) = piHalfBuffer%(iterate)
                If inRecord = 0 Then
                    Call calculateOrientation
                    RecordCounter = RecordCounter + 1
                End If
                SampleCounter = SampleCounter + 1   ' Anzahl Samples
            Next iterate
            ' Messung Anzeigen
            If RecordCounter > 0 Then
                For iterate = 0 To 2
                    TextAnalog(iterate).Text = MessArr(RecordCounter - 2, iterate + 3)
                Next iterate
                TextAnalog(6).Text = Format(Idirection * c_r2g, "000.000")
                TextAnalog(5).Text = Format(Ipitch * c_r2g, "000.000")
                TextAnalog(4).Text = Format(Ibank * c_r2g, "000.000")
                TextAnzahl.Text = CStr(RecordCounter)
            End If
            ' Pointer zu juengstem Datensatz updaten (Laenge)
            iLoopCount = iLoopCount + 1
        Else
            iRetval% = NIDAQErrorHandler(iStatus%, "DAQ_DB_HalfReady", 0)
            ' Jetzt wird abwechselnd entweder der Kompass oder Horizont neu gezeichnet
            If whichDispUpdate = True Then
                Call frmArtHorizon.CalculateBar(Ibank, Ipitch)
                whichDispUpdate = False
            Else
                Call frmVirtCompass.CalculateArrow(-Idirection)
                whichDispUpdate = True
            End If
        End If
        DoEvents
    Wend
        
    ' Abbrechen
    iStatus% = DAQ_Clear(iDevice%)
    iStatus% = DAQ_DB_Config(iDevice%, iDBmodeOFF%)

    ' Timeouts Abschalten
    iStatus% = Timeout_Config(iDevice%, -1)
    
    ' Buttons:
    ButtonExit.Enabled = True
    ButtonStart.Enabled = True
    ButtonStop.Enabled = False
End Sub

Private Sub calculateOrientation()
    Static MittelPitch As Double
    Static MittelBank As Double
    Static MittelDirection As Double
    Static Mittelx, Mittely, Mittelz As Double
    Static MittelCounter As Integer
    Dim iterate As Long
    ' Integriere die Winkelgeschwindigkeit des ENC03
    If chkNull.Value = 1 Then
        ' Die "Null" - Checkbox ist gesetzt, d.h. solange werden nun die Messwerte
        ' gemittelt. Die Box sollte dazu horizontal stillstehen.
        MittelPitch = MittelPitch + MessArr(RecordCounter, cWhichGyroPitch)
        MittelBank = MittelBank + MessArr(RecordCounter, cWhichGyroBank)
        MittelDirection = MittelDirection + MessArr(RecordCounter, cWhichGyroDirection)
        Mittelx = Mittelx + MessArr(RecordCounter, 0)
        Mittely = Mittely + MessArr(RecordCounter, 1)
        Mittelz = Mittelz + MessArr(RecordCounter, 2)
        MittelCounter = MittelCounter + 1
        If MittelCounter > 0 Then
            NullTicksH = MittelBank / MittelCounter
            NullTicksV = MittelPitch / MittelCounter
            NullTicksD = MittelDirection / MittelCounter
            NullTicksX = Mittelx / MittelCounter
            NullTicksY = Mittely / MittelCounter
            NullTicksZ = Mittelz / MittelCounter - c_NullOffsetZ
        End If
    Else
        ' Also nicht Nullen, sondern "Navigieren".
        ' Zuerst Nullsetzen der Variablen fuer die Nullung
        MittelPitch = 0
        MittelBank = 0
        MittelDirection = 0
        Mittelx = 0
        Mittely = 0
        Mittelz = 0
        MittelCounter = 0
        
        ' Transformiere den Drehgeschwindigkeitsvektor in das OriginalKoordSystem
        Dim myVector As VectorType
        myVector.arot = (MessArr(RecordCounter, cWhichGyroBank) - NullTicksH) * cGyroSensBank
        myVector.brot = (MessArr(RecordCounter, cWhichGyroPitch) - NullTicksV) * cGyroSensPitch
        myVector.crot = (MessArr(RecordCounter, cWhichGyroDirection) - NullTicksD) * cGyroSensDirection
        myVector = f_koord_transform(myVector, Ibank, Ipitch, Idirection)
        
        ' Regle die Winkelgeschwindigkeiten
        If chkFeedback.Value = 1 Then
            myVector = f_reg_omega(myVector)
        End If
        ' Integriere die transformierten und geregelten Winkelgeschwindigkeiten:
        myVector.arot = f_int_omega(myVector.arot, Ibank)
        myVector.brot = f_int_omega(myVector.brot, Ipitch)
        myVector.crot = f_int_omega(myVector.crot, Idirection)
        ' Regle die Orientierung
        If chkFeedback.Value = 1 Then
            myVector = f_reg_phi(myVector)
        End If
        
        Ibank = myVector.arot
        Ipitch = myVector.brot
        Idirection = myVector.crot
        ' Um Overflows zu vermeiden, groebste Schranken fuer die Winkel (in rad!)
        If Abs(Ipitch) > 1000 Then
            Ipitch = 0
        End If
        If Abs(Ibank) > 1000 Then
            Ibank = 0
        End If
        If Abs(Idirection) > 1000 Then
            Idirection = 0
        End If
    End If
    PosCounter = RecordCounter
End Sub

Private Sub ButtonStop_Click()
    GoOnAquire = False
End Sub

Private Sub chkDirection_Click()
    If chkDirection.Value = 1 Then
        ' Aha, der graphische Kompass ist erwuenscht
        frmVirtCompass.Show
    Else
        ' ... nicht erwuenscht
        frmVirtCompass.Hide
    End If
End Sub

Private Sub chkFeedback_Click()
    ' Aufgestaute Integralanteile von f_reg_omega() muessen auch zurueckgesetzt werden
    iao = 0
    ibo = 0
    ico = 0
End Sub

Private Sub chkHorizont_Click()
    If chkHorizont.Value = 1 Then
        ' Aha, der graphische kuenstliche Horizont ist erwuenscht
        frmArtHorizon.Show
    Else
        ' ... nicht erwuenscht
        frmArtHorizon.Hide
    End If
End Sub

Private Sub cmdInitialize_Click()
    ' Der User will die Werte also zuruecksetzen
    If RecordCounter > 0 Then
        ' Falls wir schon mitten in einer Messung drin sind, Ausrichten nach g-Vektor
        Ibank = Atn((MessArr(RecordCounter - 1, 0) - NullTicksX) / (MessArr(RecordCounter - 1, 2) - NullTicksZ))
        Ipitch = Atn((MessArr(RecordCounter - 1, 1) - NullTicksY) / (MessArr(RecordCounter - 1, 2) - NullTicksZ))
        Idirection = 0 ' Wir haben ja keinen Kompass, also Laengsrichtung = Nord
    Else
        Ibank = 0
        Ipitch = 0
        Idirection = 0
    End If
    ' aufgestaute Integralanteile von f_reg_omega() muessen auch zurueckgesetzt werden
    iao = 0
    ibo = 0
    ico = 0
End Sub

Private Sub Form_Load()
    ' Enable und disable die richtigen Buttons:
    ButtonExit.Enabled = True
    ButtonStart.Enabled = True
    ButtonStop.Enabled = False
    
    ' Initialisierung der default Samplingparameter:
    S_Freq = 300
    S_bufferSize = 2048
    S_NrCh = 8
    S_gain = 2
    frmCockpit.Top = 100
    frmCockpit.Left = 100
End Sub

Private Sub mnuSampling_Click()
    frmConfig.Show
End Sub

Private Function f_int_omega(W As Double, oldint As Double) As Double
    ' "Integrieren der Drehgeschwindigkeit zum alten Wert"
    ' Im Moment nur Addition
    f_int_omega = oldint + W / S_Freq
End Function

Private Function f_reg_omega(W As VectorType) As VectorType
    ' Diese Funktion wird nach dem Temperaturkompensieren und dem
    ' Transformieren ins Referenzkoordinatensystem aufgerufen.
    ' Sie korrigiert die Drehgeschwindigkeiten nach gewissen Kriterien, z.B.
    ' wird die Drehgeschwindigkeit normalerweise nicht ewig konstant
    ' zunehmen (einzig moegliche Korrektur um z-Achse ohne Kompass).
    ' Oder es waere ein Abgleich nach dem g-Vektor denkbar. (Aufrichtung)
    
    ' Aufrichtlogik nach dem g-Vektor (siehe f_reg_phi())
    f_reg_omega.xtrans = W.xtrans
    f_reg_omega.ytrans = W.ytrans
    f_reg_omega.ztrans = W.ztrans
    f_reg_omega.arot = W.arot + iao * c_RegOmegaA
    f_reg_omega.brot = W.brot + ibo * c_RegOmegaB
    f_reg_omega.crot = W.crot
    'f_reg_omega = w
End Function

Private Function f_reg_phi(p As VectorType) As VectorType
    ' Diese Funktion wird nach dem Integrieren der Drehgeschwindigkeit
    ' aufgerufen. Sie korrigiert die erhaltene raeumliche Orientierung
    ' nach gewissen Kriterien, z.B. Aufrichtung nach g-Vektor
    
    ' Aufrichtung nach dem g-Vektor
    Static expa, expb, expc As Double
    Static alpha, beta As Double
    Static expaold, expbold, expcold As Double
    Static tempa, tempb As Double
    ' Berechnen des Lotes: Addition von 0.0001 damit keine Div by Zero (geht, da MessArr Integer)
    alpha = Atn((MessArr(RecordCounter, 0) - NullTicksX) / (MessArr(RecordCounter, 2) - NullTicksZ + 0.0000001))
    beta = Atn((MessArr(RecordCounter, 1) - NullTicksY) / (MessArr(RecordCounter, 2) - NullTicksZ + 0.0000001))
    ' Translatorische Koordinaten des VectorTypes unveraendert zurueckgeben
    f_reg_phi.xtrans = p.xtrans
    f_reg_phi.ytrans = p.ytrans
    f_reg_phi.ztrans = p.ztrans
    ' Floating point modulo, so dass tempa, tempb innerhalb +- 2Pi
    tempa = p.arot
    tempb = p.brot
    While (tempa > c_pi): tempa = tempa - 2 * c_pi: Wend
    While (tempa < -c_pi): tempa = tempa + 2 * c_pi: Wend
    If (Abs(alpha) < c_pi / 3) And (Abs(beta) < c_pi / 3) And ((MessArr(RecordCounter, 2) - NullTicksZ) > 0) Then
        ' Keine zu extremen Winkel (Lage) --> Regeln sinnvoll
        ' Alte geregelte Werte speichern
        expaold = expa
        expbold = expb
        ' Neue geregelte Werte berechnen
        expa = p.arot + Sgn(alpha - tempa) * c_RegPhiA / S_Freq
        expb = p.brot + Sgn(beta - tempb) * c_RegPhiB / S_Freq
        ' Die Geschwindigkeit wird nur bei einer Rotationsgeschwindigkeit von unter
        ' ca. 3 Grad = 0.05 rad
        If (Abs(expaold - expa) < 0.1 / S_Freq) And (Abs(expbold - expb) < 0.1 / S_Freq) Then
            ' Korrekturterm iao wird durch das Differential der Position erweitert.
            iao = iao - (expaold - expa)
            ' Dasselbe fuer ibo
            ibo = ibo - (expbold - expb)
            ' Rueckgabewert
            f_reg_phi.arot = expa
            f_reg_phi.brot = expb
            f_reg_phi.crot = p.crot     ' Richtung kann ohne Kompass nicht geregelt werden
        Else
            ' Rueckgabewert ungeregelt
            f_reg_phi.arot = p.arot
            f_reg_phi.brot = p.brot
            f_reg_phi.crot = p.crot
        End If
    Else
        ' Nicht regeln, da Lage dazu unguenstig
        f_reg_phi.arot = p.arot
        f_reg_phi.brot = p.brot
        f_reg_phi.crot = p.crot
    End If
    'f_reg_phi = p
End Function

Private Function f_koord_transform(v As VectorType, a As Double, b As Double, c As Double) As VectorType
    ' Diese Funktion transformiert die translatorischen
    ' Koordinaten (position, geschwindigkeit, beschleunigung)
    ' in das Ursprungskoordinatg ensystem.
    ' Optimierungsmoeglichkeit: statische Variablen fuer Terme wie six*siy*coz-cox*siy
    Static cosa, cosb, cosc As Double     ' Cosinus von rot*
    Static sina, sinb, sinc As Double     ' Sinus von rot*
    Static Vector As VectorType        ' Resultatevektor
    ' Berechnen der Sinuesser und Cosinuesser
    cosa = Cos(a)
    cosb = Cos(b)
    cosc = Cos(c)
    sina = Sin(a)
    sinb = Sin(b)
    sinc = Sin(c)
    ' transformationen der Rotatorischen Komponenten
    ' Der Rotationsvektor um die Querachse (Winkel b) muss erst noch parallel zu x-y-Ebene transformiert werden
    ' (um den Winkel c um die y-Achse des Geraetes = Laengsachse)
    Vector.brot = (cosa) * v.brot + (sina) * v.crot
    ' Der Rotationsvektor um die Laengsachse bleibt sich gleich
    Vector.arot = v.arot + ((sina) * v.brot - cosa * v.crot) * Tan(b)
    ' Der Rotationsvektoranteil um die Hochachse (parallel zu z-Achse)
    Vector.crot = ((cosa) * v.crot - (sina) * v.brot) / cosb
    f_koord_transform = Vector
End Function
